<?php

// Exit if accessed directly
defined( 'ABSPATH' ) || exit;

/**
 * WWS_Admin_Enqueue_Scripts class responsable to load all the scripts and styles.
 */
class WWS_Admin_Enqueue_Scripts {

    public function __construct() {
        add_action( 'admin_enqueue_scripts', array( $this, 'admin_enqueue_scripts' ) );
    }

    /**
     * Load all the required backend scripts
     * @return void
     * @since 1.3
     */
    public function admin_enqueue_scripts( $hook ) {
        if ( $this->is_my_admin_page( $hook ) !== true ) {
            return;
        }
        
        // Load thickbox
        wp_enqueue_script('thickbox');
        wp_enqueue_style('thickbox');

        // Select2
        wp_enqueue_style( 'wws-select2', WWS_PLUGIN_URL . 'assets/libraries/select2/select2.min.css', array(), '4.0.10' );
        wp_enqueue_script( 'wws-select2', WWS_PLUGIN_URL . 'assets/libraries/select2/select2.min.js', array(), '4.0.10', true );
                
        // Datatable
        wp_enqueue_style( 'wws-datatable', WWS_PLUGIN_URL . 'assets/libraries/dataTables/jquery.dataTables.min.css', array(), '1.10.19');
        wp_enqueue_script( 'wws-datatable', WWS_PLUGIN_URL . 'assets/libraries/dataTables/jquery.dataTables.min.js', array(), '1.10.19', true);
        wp_enqueue_script( 'wws-datatable-button-html5', WWS_PLUGIN_URL . 'assets/libraries/dataTables/buttons.html5.min.js', array(), '1.5.2', true );
        wp_enqueue_script( 'wws-datatable-button', WWS_PLUGIN_URL . 'assets/libraries/dataTables/dataTables.buttons.min.js', array(), '1.5.2', true );

        // Timepicker v1.11.12
        wp_enqueue_script( 'wws-timepicker', WWS_PLUGIN_URL . 'assets/libraries/timepicker/wws-timepicker.js', array(), '1.11.12', true );
        wp_enqueue_style( 'wws-timepicker', WWS_PLUGIN_URL . 'assets/libraries/timepicker/wws-timepicker.css', array(), '1.11.12' );

        // Plugin icons
        wp_enqueue_style( 'wws-icons', WWS_PLUGIN_URL . '/assets/css/wws-icons.css', array(), WWS_PLUGIN_VER );

        // Load admin scripts
        wp_enqueue_style( 'wws-admin-style', WWS_PLUGIN_URL . 'assets/css/wws-admin-style.css', array(), WWS_PLUGIN_VER );
        wp_enqueue_script( 'wws-admin-script', WWS_PLUGIN_URL . 'assets/js/wws-admin-script.js', array(), WWS_PLUGIN_VER, true );
        wp_localize_script( 'wws-admin-script', 'wwsAdminObj', array(
            'admin_url' => admin_url( 'admin-ajax.php?ver=' . uniqid() ),
        ) );
    }


    /**
     * Check current admin page is plugin admin page or not.
     * @param  string  $hook
     * @return boolean
     */
    public function is_my_admin_page( $hook ) {
        if ( $hook == 'toplevel_page_wc-whatsapp-support' 
         ||  $hook == 'whatsapp-support_page_wc-whatsapp-support-gdpr-setting'
         ||  $hook == 'whatsapp-support_page_wc-whatsapp-support_plugin-support'
         ||  $hook == 'whatsapp-support_page_wc-whatsapp-support-analytics'
         ||  $hook == 'whatsapp-support_page_wc-whatsapp-support-fb-ga-analytics' ) {
            return true;
        }

        return false;
    }

} // end of class WWS_Admin_Enqueue_Scripts

$wws_admin_enqueue_scripts = new WWS_Admin_Enqueue_Scripts;